
// -----------------------------------------------------------------------------------------
//                      C O L O R S
//------------------------------------------------------------------------------------------ 
#declare Transparent = rgbt 1 ;
#declare C_clear  =         rgbt 1 ;
#declare C_white =          color rgb<1,1,1>  ;
#declare C_black =          color rgb<0,0,0>  ;

#declare C_red =            color rgb<1,0,0>  ;  
#declare C_red_dark =       color rgb<.5,0,0>  ; 
#declare C_maroon =         color rgb<.45,.02,.02>  ;
#declare C_green =          color rgb<0,1,0>  ;  
#declare C_yellow =         color rgb<1,.9,0>  ;


#declare C_orange =         color rgb<1,1,0>  ;
#declare C_copper =         color rgb <0.40, 0.20, 0.15>;  
#declare C_silver =         color rgb <0.85, 0.85, 0.8>;   
#declare C_gold =           color red 0.82 green 0.6 blue 0.196078;
#declare C_gold_bright=     color rgb <0.90, 0.65, 0.15>;

#declare C_light_blue =     color red 0.6 green 0.8 blue 1; 
#declare C_horizon_blue =   color red .82 green 1 blue .98; 
#declare C_blue_charcoal =  color rgb <.07,.09,.18> ; 
#declare C_blue =           color rgb<0,.5,.9>  ;
#declare C_blue_dark =      color rgb<.05,.5,.75> *.35  ;
  
  
#declare C_light_green =    color rgb<.75,1,.9>  ; 

//---grays
#declare C_gray_dark =      color rgb<0.07,0.07,0.07> ;
#declare C_gray_black =     color rgb<0.03,0.03,0.03>  ; 
#declare C_gray5 =          color red 0.05 green 0.05 blue 0.05;
#declare C_gray10 =         color red 0.1 green 0.1 blue 0.1;   
#declare C_gray20 =         color red 0.2 green 0.2 blue 0.2;
#declare C_gray30 =         color red 0.3 green 0.3 blue 0.3; 
#declare C_gray40 =         color red 0.4 green 0.4 blue 0.4;
#declare C_gray50 =         color red 0.5 green 0.5 blue 0.5;
#declare C_gray60 =         color red 0.6 green 0.6 blue 0.6; 
#declare C_gray70 =         color red 0.7 green 0.7 blue 0.7;   
#declare C_gray80 =         color red 0.8 green 0.8 blue 0.8; 
#declare C_gray90 =         color red 0.9 green 0.9 blue 0.9;

#declare C_putty =          color red 1 green 0.7 blue 0.50;
#declare C_tan =            color red 0.85 green 0.66 blue 0.5;
#declare C_tan_dark =       color red 0.66 green 0.5 blue 0.4;


#declare C_rust_red =       color rgb <0.6, 0.3, 0.25> ;
#declare C_rust_red_film =  color rgbt <0.5, 0.3, 0.25,.5> ;
#declare C_rust_gray =      color rgb <0.80, 0.80, 0.85> ;
#declare C_rust_gray_dark = color rgb <0.70, 0.70, 0.80>  ;
#declare C_rust_gray_film = color rgbt <0.5, 0.5, 0.5,.5> ; 
#declare C_rust_tan_film =  color rgbt <0.75, 0.6, 0.5,.75> ; 

#declare C_brass =          color rgb  <0.62, 0.33, 0.1>;
#declare C_brass_film =     color rgbt <0.62, 0.33, 0.1, .8>;

#declare C_galvanize1 =     color rgb <0.90, 0.90, 0.95> ;
#declare C_galvanize2 =     color rgb <0.80, 0.80, 0.85>  ;
#declare C_breaker_black =  color rgb <0.15,.15,.17> *.3 ;
#declare C_panel_gray =     color rgb <0.15,.15,.17> * 2 ;
#declare C_gray_blue =      color red 0.8 green 0.8 blue 0.9 ;

#declare RGB_green_olive =  rgb <0.4, 0.6, 0.2> ;
#declare RGB_green_gray =   rgb <0.5, 0.6, 0.4> ; 
#declare RGB_yellow_gray =  rgb <0.7, 0.8, 0.4> ;
#declare RGB_brown_gray =   rgb <0.879, 0.55, 0.32> ;  
#declare C_brown_gray =     color red 1 green 0.6 blue 0.32 ; 
#declare C_teal =           color rgb<.30,.51,.54> ;
#declare C_purple =         color red 0.18 green 0 blue 0.26;
#declare C_teal =           color red 0.0 green 0.64 blue 1.0;  
#declare C_skylight_blue =  color red .10 green .15 blue .2 ;
#declare C_skylight_warm =  color red .06 green .04 blue .03 ;
#declare C_dark_gray_blue = color red .04 green .08 blue .10 ;      
#declare C_gray_blue =      color red 0.8 green 0.8 blue 0.9 ;
#declare C_dark_cyan =      color red 0 green.07 blue .11 ; 

#declare C_water =          colour red .03 green .04 blue .05 filter 1 ;
#declare C_water_fade_A =   colour red .05 green .06 blue .07 filter .2 ;
#declare C_water_fade_B =   colour red .05 green .06 blue .07 filter .2 ;
#declare C_water_fade_C =   colour red .05 green .06 blue .07 filter .2 ;
#declare C_yellow_dull  =   color rgb<1,.9,.10>  ;


#declare C_sea_green =      color rgb <.4,1,.6> ;

#declare f = .0039  ;                             
#declare tR = 107*f ;
#declare tG = 176*f ;
#declare tB = 189*f ;
#declare C_teal = color rgb<tR,tG,tB> ;
#declare C_red50 = rgbf<1,0,0,.5>;


   
   


// -----------------------------------------------------------------------------------------
//                      C O L O R   M A P S
//------------------------------------------------------------------------------------------ 



#declare C_steel_black =
color_map {
    [ 0.0  C_gray_black *.5]  
    [ 0.3  C_gray_black *1]
    [ 0.5  C_gray_black *0.5]
    [ 0.8  C_gray_black *0.5] 
    [ 1    C_gray_black *1]
    }

 
#declare C_steel_black_normal =
color_map {
    [ 0.0  C_black ]  
    [ 0.3  C_white ]
    [ 0.5  C_black ]
    [ 0.8  C_black ] 
    [ 1    C_white ]
    }   
    
#declare C_map_old_copper =
color_map {
    [ 0.0  C_copper *.83]  
    [ 0.3  C_copper *.83]
    [ 0.5  C_gray60 *.63]
    [ 0.8  C_copper *.63] 
    [ 1    C_copper *.83]
    }


#declare C_map_old_brass =
color_map {
    [ 0.0  C_brass *.83]  
    [ 0.3  C_brass *.93]
    [ 0.5  C_brass *.63]
    [ 0.8  C_brass *.63] 
    [ 1    C_brass *.83]
    }




       
#declare C_map_rust_gray = 
color_map {
    [0.0        C_rust_gray]
    [0.1        C_rust_gray_dark]
    [0.3        C_rust_gray_dark * .9] 
    [0.55       C_rust_gray * 1.5]
    [0.85       C_rust_gray * 1.5]
    [0.9        C_rust_gray_dark]
    [1.000      C_rust_gray]
}

#declare C_map_rust_gray_dark = 
color_map {
    [0.0        C_rust_gray * .2]
    [0.1        C_rust_gray_dark * .2]
    [0.3        C_rust_gray_dark * .2] 
    [0.55       C_rust_gray * .2]
    [0.85       C_rust_gray * .2]
    [0.9        C_rust_gray_dark * .2]
    [1.000      C_rust_gray * .2]
}





#declare C_map_gray_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_gray80 ]
    [0.3        C_rust_gray_film * .9] 
    [0.4        C_clear * 1]
    [0.85       C_clear * 1.5]
    [0.9        C_rust_gray_film * .8]
    [1.000      C_clear]
}


#declare C_map_rust_red = 
color_map {
    [0.0        C_rust_gray ]
    [0.2        C_rust_red * .5]
    [0.25       C_rust_red * .7] 
    [0.4        C_rust_gray * 1]
    [0.85       C_rust_gray * 1.5]
    [0.9        C_rust_red * .6]
    [1.000      C_rust_gray]
}


#declare C_map_rust_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_rust_red_film ]
    [0.25       C_rust_red_film * 1.5] 
    [0.35       C_rust_gray_film]
    [0.45       C_clear]
    [0.9        C_clear]
    [1.000      C_clear]
}



#declare C_map_brass_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_brass_film ]
    [0.25       C_brass_film * 1.5] 
    [0.35       C_brass_film]
    [0.45       C_clear]
    [0.9        C_clear]
    [1.000      C_clear]
}






#declare C_map_rust_normal = 
color_map {
    [0.0        C_white ]
    [0.2        C_gray50 ]
    [0.25       C_black ] 
    [0.35       C_gray50 ]
    [0.45       C_gray80 ]
    [0.9        C_white ]
    [1.000      C_white ]
}


#declare C_map_dirt_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_black ]
    [0.3        C_gray20 ] 
    [0.5        C_tan * .2]
    [0.85       C_clear ]
    [0.9        C_rust_red * .6]
    [1.000      C_black]
}



#declare C_map_pitted_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_clear ]
    [0.35       C_gray20 ] 
    [0.5        C_tan * .2]
    [0.85       C_clear ]
    [0.9        C_clear ]
    [1.000      C_clear]
}

#declare C_map_oxidized_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_clear ]
    [0.5        C_clear ] 
    [0.65       C_rust_tan_film]
    [0.7        C_gray70]
    [0.85       C_clear ]
    [0.9        C_clear ]
    [1.000      C_clear]
}


#declare C_map_pitted_normal = 
color_map {
    [0.0        C_white ]
    [0.2        C_white ]
    [0.35       C_gray20 ] 
    [0.5        C_black ]
    [0.85       C_white ]
    [0.9        C_white ]
    [1.000      C_white ]
}




    
#declare C_map_dent_A = 
color_map {
    [0.0        C_white ]
    [0.2        C_gray50 ]
    [0.3        C_black ] 
    [0.4        C_black ]     
    [0.5        C_white ]
    [0.85       C_white ]
    [0.9        C_gray50 ]
    [1.000      C_white ]
}



   
    
#declare C_map_galvanize = 
color_map {
    [0.0        C_galvanize1]
    [0.1        C_galvanize2 * 1.5]
    [0.3        C_galvanize2 * .9] 
    [0.55       C_galvanize1 * 1.5]
    [0.85       C_galvanize1 * 1.5]
    [0.9        C_galvanize2 * 2]
    [1.000      C_galvanize1]
}

#declare C_map_enviroment_sunny =
color_map {
    [ 0.0     C_gray60 ]  
    [ 0.40    C_white ]
    [ 0.50    C_horizon_blue ]
    [ 0.53    C_light_blue ]
    [ 1.0     C_blue ]
    }
   
        
      
#declare C_map_teal = 
color_map {
    [0.000 rgb C_teal]
    [0.2 rgbt <tR, tG, tB, .1>]
    [0.7 rgbt <tR, tG, tB, .1>]
    [0.85 rgb C_teal]
    [1.000 rgb C_teal]
} 
                          
#declare C_map_agate_A =
color_map {
    [ 0.0     RGB_green_olive ]
    [ 0.3     RGB_green_gray ]
    [ 0.5     RGB_yellow_gray ]
    [ 0.7     RGB_brown_gray ]
    [ 1.0     RGB_green_olive ]
    }
        

#declare C_map_mud_A = 
color_map {
    [0.000 rgb <0.625, 0.659, 0.455>]
    [0.171 rgb <0.582, 0.449, 0.320>]
    [0.274 rgb <0.157, 0.151, 0.122>]
    [0.393 rgb <0.625, 0.619, 0.455>]
    [0.564 rgb <0.582, 0.519, 0.420>]
    [0.701 rgb <0.482, 0.392, 0.278>]
    [1.000 rgb <0.625, 0.659, 0.455>]
}



#declare C_map_steel = 
color_map {
    [0.000 rgb <0.535, 0.525, 0.535>]
    [0.171 rgb <0.549, 0.549, 0.520>]
    [0.274 rgb <0.457, 0.451, 0.462>]
    [0.393 rgb <0.625, 0.625, 0.625>]
    [0.564 rgb <0.582, 0.540, 0.520>]
    [0.701 rgb <0.552, 0.532, 0.578>]
    [1.000 rgb <0.535, 0.525, 0.535>]
}


#declare C_map_steel = 
color_map {
    [0.000 rgb <0.535, 0.525, 0.535>]
    [0.171 rgb <0.549, 0.549, 0.520>]
    [0.274 rgb <0.557, 0.551, 0.562>]
    [0.393 rgb <0.625, 0.625, 0.625>]
    [0.564 rgb <0.582, 0.540, 0.520>]
    [0.701 rgb <0.552, 0.532, 0.578>]
    [1.000 rgb <0.535, 0.525, 0.535>]
}
        
        
#declare C_map_gold = 
color_map {
    [0.000 rgb <0.70, 0.60, 0.45>]
    [0.171 rgb <0.65, 0.55, 0.35>]
    [0.274 rgb <0.58, 0.35, 0.25>]
    [0.393 rgb <0.65, 0.65, 0.35>]
    [0.564 rgb <0.55, 0.45, 0.25>]
    [0.701 rgb <0.65, 0.55, 0.35>]
    [1.000 rgb <0.70, 0.60, 0.45>]
}

#declare C_shroom_grad_A =
color_map {
	[0.0 color C_gold]  
	[0.5 color C_gold]  
	[.7 color C_white]  
	[.9 color C_tan_dark]
	[1.0 color C_tan_dark]
}     
        
        
#declare C_shroom_grad_B =
color_map {
	[0.0 color C_horizon_blue]  
	[0.2 color C_gold]  
	[.7 color C_gold]  
	[.9 color C_horizon_blue]
	[1.0 color C_horizon_blue]
}          


#declare CM_purple_teal = 
 color_map {  
     [0.0 .5 color C_black color C_light_blue]
     [0.5 1.0 color C_light_blue color C_black]    
  }
          
#declare CM_sky_dome_teal_purple_2 = 
 color_map {  
     [0.0 .5 color C_teal color C_purple]
     [0.5 1.0 color C_purple color C_teal]    
  }


#declare CM_sky_dome_brown_blue =
 color_map { 
     [0.0 .5 color C_teal color C_brown_gray]
     [0.5 1.0 color C_brown_gray color C_teal]  
  }

#declare CM_sky_dome_blue_violet = 
 color_map { 
     [0.0 .1 color C_teal color C_teal] 
     [0.1 .5 color C_teal color C_horizon_blue] 
     [0.5 .9 color C_horizon_blue color C_teal]  
     [0.9 1.0 color C_teal color C_teal]  
  }

              
#declare CM_sky_dome_teal_purple = 
color_map { 
    [0.0 .1 color C_teal color C_teal] 
    [0.1 .5 color C_teal color C_purple]
    [0.5 .9 color C_purple color C_teal]  
    [0.9 1.0 color C_teal color C_teal]  
}

#declare CM_water_fade = 
color_map {
    [0.000 C_water]
    [0.171 C_water]
    [0.274 C_water_fade_A]
    [0.393 C_water_fade_B]
    [0.564 C_water]
    [0.701 C_water_fade_C]
    [1.000 C_water]
}


#declare C_map_enviroment_sunny =
color_map {
    [ 0.0     C_gray20 ]  
    [ 0.1     C_gray20 ]
    [ 0.3     C_horizon_blue ]
    [ 0.6     C_light_blue ]
    [ 1.0     C_blue ]
    }








// -----------------------------------------------------------------------------------------
//                     P I G M E N T S
//------------------------------------------------------------------------------------------   
#declare P_mud_granite =    pigment { granite color_map {   C_map_mud_A } scale 1 warp { turbulence .5 }} 
#declare P_mud_leopard =    pigment { leopard color_map {   C_map_mud_A } scale 1 warp { turbulence 3 }} 
#declare P_mud_bozo =       pigment { bozo color_map {      C_map_mud_A } scale 1 warp { turbulence 3 }} 
#declare P_mud_wrinkles =   pigment { wrinkles color_map {  C_map_mud_A } scale 1 warp { turbulence 3 }} 
#declare P_mud_crackle =    pigment { crackle color_map {   C_map_mud_A } scale 1 warp { turbulence 3 }} 
#declare P_mud_agate =      pigment { agate color_map {     C_map_mud_A } scale 1 warp { turbulence 1 }} 
#declare P_steel_leopard =  pigment { leopard color_map {   C_map_steel } scale 1 warp { turbulence 2 }} 
#declare P_steel_bozo =     pigment { bozo color_map {      C_map_steel } scale 1 warp { turbulence 4 }} 
#declare P_steel_wrinkles = pigment { wrinkles color_map {  C_map_steel } scale 1 warp { turbulence 6 }} 
#declare P_steel_agate =    pigment { agate color_map {     C_map_steel } scale 1 warp { turbulence 5 }} 
#declare P_gold_agate =     pigment { agate color_map {     C_map_gold  } scale 1 warp { turbulence 5 }} 
#declare P_clear_black =    pigment { color C_black transmit 1 }
#declare P_clear_white =    pigment { color C_white transmit 1 }



// -----------------------------------------------------------------------------------------
//                     I N T E R I O R S 
//------------------------------------------------------------------------------------------    


#declare I_white=
  interior {
    ior 1.5  
    fade_colour <1,1,1>
    fade_distance 1.0
    fade_power .2
  }

 #declare I_clear=
  interior {
    ior 1.5  
    fade_colour <1,1,1>
    fade_distance 1.0
    fade_power .2
  }

#declare I_dark=
  interior {
    ior 1.5  
    fade_colour <.5,.5,.5>
    fade_distance 1.0
    fade_power .2
  }
  
#declare I_green =
    interior {
        ior 1.6
        fade_colour <0,.7,.2>
        fade_distance .5
        fade_power 2
        }  
        
#declare I_green_light =
    interior {
        ior 1.6
        fade_colour <.75,1,.9>
        fade_distance .5
        fade_power 2
        }        

#declare I_blue =
    interior {
        ior 1.6
        fade_colour <0,.8,1>
        fade_distance .5
        fade_power 2
        }
 
#declare I_blue_dark =
    interior {
        ior 1.6
        fade_colour <.1,.3,.5>
        fade_distance .5
        fade_power 2
        }
        
#declare I_red =
    interior {
        ior 1.6
        fade_colour <1,0,0>
        fade_distance .5
        fade_power 2
        }  


#declare I_gold =
    interior {
        ior 1.6
        fade_colour <0.90, 0.65, 0.15>
        fade_distance .5
        fade_power 2
        } 
        
        
#declare I_solid =
    interior {
        ior 1
        fade_colour <0,0,0>
        fade_distance 0
        fade_power 0
        }      

#declare I_glass =  interior { ior 1.33 }




// -----------------------------------------------------------------------------------------
//                      F I N I S H E S
//------------------------------------------------------------------------------------------                 
#declare F_soft_plastic =
finish {
    ambient .3
    diffuse 1   
    phong 1
    phong_size 20 
    reflection {.001, .1 fresnel} 
}                      

#declare F_concrete_smooth =
finish {
    ambient .3
    diffuse 1   
    phong 1
    phong_size 60 
    reflection {.01, .5 fresnel} 
} 


#declare F_rubber =
finish {
    ambient .2
    diffuse 1   
    phong .3
    phong_size 5  
}


#declare F_flat =
finish {
    ambient 0
    diffuse 1   
    phong .1
    phong_size 20  
} 

#declare F_gloss =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 100  
    reflection {.01, .72 fresnel}
}
      
#declare F_satin =
finish {
    ambient .2
    diffuse 1   
    phong .5
    phong_size 40  
}

#declare F_dull =
finish {
    ambient .2
    diffuse 1   
    phong .1
    phong_size 10  
}

#declare F_metal_dull  =
finish {
     reflection {.001, .3 fresnel on } 
     conserve_energy 
     brilliance 5   
     ambient .2
     diffuse 1
     phong .1    
     phong_size 60   
     metallic 1
     specular .8 
     roughness .15  
     reflection .1  
}


#declare F_metal_lead  =
finish {
    reflection {0, .5 fresnel on }
    conserve_energy 
    brilliance 5
    ambient .1
    diffuse 1 
    phong 5    
    phong_size 20
    metallic
    specular .4
    roughness 1/20
    reflection .10    
}



#declare F_metal_polished  =
finish {
    reflection {0, 1 fresnel on }
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .5 
    phong 5    
    phong_size 40
    metallic
    specular .4
    roughness 1/20
    reflection .5   
}



#declare F_glass_cover =
     finish {
     reflection {0, .5 fresnel on } 
     conserve_energy 
     ambient 0
     diffuse .5 
     phong 5     
     phong_size 100   
     metallic 0
     specular .25 
     roughness 1/10  
     diffuse 1
}


#declare F_glow =
    finish {
    ambient 1
    emission 5
    } 
    
     
#declare F_plastic_gloss2 =    
    finish {
    reflection {.03, .2 fresnel on } 
    conserve_energy 
    brilliance 1
    ambient .1
    diffuse .5 
    phong 5    
    phong_size 80
    specular .3 
    roughness .05
    }
         
#declare F_plastic =
finish {
    ambient .2
    diffuse 1   
    phong .7
    phong_size 80  
    //reflection {.05, .7 fresnel}
}

#declare F_wood_shine =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 60  
    reflection {.001, .2 fresnel}
}

#declare F_smooth_paint =
finish {
    ambient .2
    diffuse 1   
    phong 1.2
    phong_size 60  
    reflection {.001, .2 fresnel}
}


#declare F_metal_soft  =
finish {  
    reflection {.01, .05 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient .1
    brilliance 5
    diffuse 1 
    phong 1    
    phong_size 20
    metallic
    specular 3 
    roughness .01
}

#declare F_metal_steel  =
finish {  
    reflection {.001, .2 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient 0
    brilliance 5
    diffuse 1 
    phong 1.5    
    phong_size 20
    metallic
    specular 3 
    roughness .01
    reflection .2 
}


#declare F_old_steel  =
finish {  
    reflection {.001, .2 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient .1
    diffuse .8 
    metallic
    specular 3 
    roughness .21
    reflection .15 
}




#declare F_metal_hard  =
finish {  
    reflection {.01, 1 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient 0
    brilliance 5
    diffuse 1 
    phong 2    
    phong_size 100
    metallic
    specular 1 
    roughness 1/100
    reflection .2
} 

#declare F_metal_hard2  =
finish {  
    reflection {.01, 1 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient .1
    brilliance 5
    diffuse 1 
    phong 2    
    phong_size 100
    metallic
    specular 1 
    roughness .2
    reflection .1
}

#declare F_metal_galvanize  =
finish {  
    conserve_energy 
    brilliance 5
    ambient .2
    brilliance 5
    diffuse 1 
    phong 2    
    phong_size 40
    specular 2 
    roughness .01
    reflection .1
}

#declare F_glass =
  finish {
    specular 0.7
    roughness 0.001
    ambient .5
    diffuse .5
    reflection { .2, 1.0 fresnel on }
    conserve_energy
  } 
  
#declare F_glass_dark =
  finish {
    specular .02
    roughness 0.01   
    phong 1     
    phong_size 100  
    ambient .5
    diffuse 0
    reflection { .2, 1.0 fresnel on }
    conserve_energy
  } 
  
  #declare F_hazy_glass =
     finish {
     reflection {0, .85 fresnel on } 
     conserve_energy
     phong 10     
     phong_size 60   
     metallic 1
     specular 30 
     roughness 1/10 
    }
          

  #declare F_hard_glass =
     finish {
     reflection {.2, 1 fresnel on } 
     conserve_energy
     phong 5     
     phong_size 100   
     metallic 0
     specular .25 
     roughness 1/10  
     diffuse 1
    }

  #declare F_milky =
     finish {
     reflection {.4, .6 fresnel on } 
     conserve_energy
     phong 1     
     phong_size 60   
     metallic 0
     specular .2 
     roughness 1/10 
    }

#declare F_metal_smooth =    
    finish {
    reflection {.3, .6 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient 0
    brilliance 2
    diffuse 1 
    phong 1    
    phong_size 100
    metallic
    specular .5
    roughness .15
    }  
            
            
            
#declare F_metal_flat =
    finish {
        reflection {0, 1 fresnel on falloff 1.0 exponent 1.0 metallic 0 } 
        conserve_energy
        phong .5     
        phong_size 10 
        diffuse .5  
        metallic 1
        specular .7 
        roughness .2
        }
             
#declare F_metal_rough =
    finish {
        reflection {0.001, .1 fresnel on } 
        conserve_energy
        ambient .2
        phong .2     
        phong_size 5 
        diffuse .8  
        specular .2 
        roughness .4
        }          
             
#declare F_stone_smooth =
    finish {
        reflection {.1, .3 
            fresnel on 
            falloff 1 
            exponent 1.0 
            metallic 0 
            } 
        conserve_energy
        phong .3     
        phong_size 30 
        diffuse .75 
        specular .2 
        roughness .8
        }  


#declare F_glossy =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 60  
    reflection {.001, .1 fresnel}
}


    
// -----------------------------------------------------------------------------------------
//                      N O R M A L S 
//------------------------------------------------------------------------------------------   
#declare N_ripple_A = normal { bozo 0.2 scale 0.2 bump_size 2}  
#declare N_ripple_large = normal{N_ripple_A scale 10 bump_size 5}
#declare N_small_bumps = normal { leopard bump_size 10 scale 1 warp { turbulence 1 }}
#declare N_granite = normal { granite 1 bump_size 1 scale 1 warp { turbulence .5 }} 
#declare N_leopard = normal { leopard bump_size 9 scale .5 warp { turbulence 6 }} 
#declare N_mud_bozo = normal { bozo bump_size 5 scale 1 warp { turbulence 3 }} 
#declare N_mud_wrinkles = normal { wrinkles bump_size 2 scale 1 warp { turbulence 3 }} 
#declare N_crackle = normal { crackle bump_size .1 scale 1 warp { turbulence 1 }}  
#declare N_mud_agate = normal { agate bump_size 2 scale 1 warp { turbulence 1 }} 

#declare N_crackle_A =
normal { 
    pigment_pattern{ 
        crackle 
        turbulence 0.2
        colour_map {[0.00, rgb 0]
                    [0.25, rgb 1]
                    [0.95, rgb 1]
                    [1.00, rgb 0]
                    } 
     }
} 

#declare N_leopard_A =
normal { 
    pigment_pattern{ 
        leopard 
        turbulence 0.2
        colour_map {[0.00, rgb 0] 
                    [0.5, rgb 0]
                    [0.6, rgb 1]
                    [0.9, rgb 1]
                    [1.00, rgb 0]
                    } 
     }
} 

#declare N_granite_A =
normal { 
    pigment_pattern{ 
        granite 
        turbulence 0.2
        colour_map {[0.00, rgb 1] 
                    [0.5, rgb 1]
                    [0.7, rgb 0]
                    [0.9, rgb 0]
                    [1.00, rgb 1]
                    } 
     } 
     bump_size .02
} 

#declare N_dent_A =  
normal { 
    pigment_pattern{ 
        granite 
        turbulence 0.2
        colour_map {[0.00, rgb 1] 
                    [0.4, rgb 1]
                    [0.5, rgb 0]
                    [0.8, rgb 0]
                    [0.9, rgb 1]
                    [1.00, rgb 1]
                    } 
     } 
     bump_size .02
}
     
     
     
     
     

// -----------------------------------------------------------------------------------------
//                      T E X T U R E S
//------------------------------------------------------------------------------------------ 
       
#declare T_clear_black = texture { pigment { color C_black transmit 1 }}  
#declare T_clear_white = texture { pigment { P_clear_white }}
#declare T_red_transmit = texture{ pigment{ rgb C_red transmit 1 }} 
#declare T_gold = texture{ pigment{ rgb C_gold }} 
#declare T_gold_bright = texture{ pigment{ rgb C_gold_bright }} 
#declare T_black = texture{ pigment{ rgb C_black transmit 0 }}
#declare T_gray10 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray20 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray30 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray40 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray50 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray60 = texture{ pigment{ rgb C_gray60 transmit 0 }}  
#declare T_gray70 = texture{ pigment{ rgb C_gray70 transmit 0 }}
#declare T_gray80 = texture{ pigment{ rgb C_gray80 transmit 0 }}
#declare T_white = texture{ pigment{ rgb C_white transmit 0 }}  
#declare T_tan = texture{ pigment{ rgb C_tan transmit 0 }}   
#declare T_tan_dark = texture{ pigment{ rgb C_tan_dark transmit 0 }}  
#declare T_red = texture{ pigment{ rgb C_red transmit 0 }}  

//--- steel old
#declare sz = <.1,.2,.1> ;   
#declare turb = 1.1; 
#declare bump = .1; 

#declare T_metal_steel_old =
texture { 
    pigment { 
        spotted 
        color_map {C_map_rust_gray} 
        turbulence turb
        scale sz
        } 

    finish{F_metal_steel}
    
    normal {
         crackle 
         turbulence turb 
         bump_size bump
         scale sz
     }   
 }



//--- steel old spotted
#declare sz = <1,1,1>*.5 ;   
#declare turb = 1.1; 
#declare bump = .1; 

#declare T_metal_steel_spotted =
texture { 
    pigment { 
        spotted 
        color_map {C_map_rust_overlay} 
        turbulence turb
        scale sz
        } 

    finish{F_metal_steel}
    
    normal {
        pigment_pattern{ 
            spotted 
            color_map {C_map_rust_normal} 
            turbulence turb
            scale sz
         }  
         bump_size bump
     }   
 }

//--- steel old spotted
#declare sz = <1,1,1>*.5 ;   
#declare turb = 1.1; 
#declare bump = .1; 

#declare T_metal_brass_spotted =
texture { 
    pigment { 
        spotted 
        color_map {C_map_brass_overlay} 
        turbulence turb
        scale sz
        } 

    finish{F_metal_steel}
    
    normal {
        pigment_pattern{ 
            spotted 
            color_map {C_map_rust_normal} 
            turbulence turb
            scale sz
         }  
         bump_size bump
     }   
 }


//--- steel old pitted
#declare sz = <1,1,1>*.5 ;   
#declare turb = .7; 
#declare bump = .15; 

#declare T_metal_pitted =
texture { 
    pigment { 
        spotted 
        color_map {C_map_pitted_overlay} 
        turbulence turb
        scale sz
        } 

    finish{F_dull}
    
    normal {
        pigment_pattern{ 
            spotted 
            color_map {C_map_pitted_normal} 
            turbulence turb
            scale sz
         }  
         bump_size bump
     }   
 }


//--- steel oxidized
#declare sz = <1,1,1>*.5 ;   
#declare turb = .17; 
#declare bump = .05; 

#declare T_metal_oxidized =
texture { 
    pigment { 
        spotted 
        color_map {C_map_oxidized_overlay} 
        turbulence turb
        scale sz
        } 

    finish{F_metal_dull}
    
    normal {
        pigment_pattern{ 
            spotted 
            color_map {C_map_pitted_normal} 
            turbulence turb
            scale sz
         }  
         bump_size bump
     }   
 }

 


//--- steel black
#declare sz = .1;   
#declare turb = .1; 
#declare bump = 2; 

#declare T_steel_black =
texture { 
    pigment { 
        spotted 
        color_map {C_steel_black} 
        turbulence turb
        scale sz
        } 

    finish{F_metal_rough}
    
    normal {
        spotted 
        turbulence turb
        scale sz
        bump_size bump
     }   
 }



     







//--- galvanize
#declare sz = .1;   
#declare turb = 1.1; 
#declare bump = .3; 

#declare T_galvanize =
texture { 
    pigment { 
        spotted 
        color_map {C_map_galvanize} 
        turbulence turb
        scale sz
        } 

    finish{F_metal_galvanize}
    
    normal {
         crackle 
         turbulence turb 
         bump_size bump
         scale sz*2
     }   
 }


#declare T_glass =
texture {
    pigment{ rgbf <0.0, 0.0, 0,1, 0.9> }
    finish {
        reflection {0.3, 1 fresnel}
        conserve_energy
    }
} 


#declare T_map_steel = 
texture {
  granite
  texture_map {
    [.2  pigment {
             color rgb <.77,.77,.75>
             transmit 0
           }
           finish{F_metal_flat}
  
         ]
    [.28   pigment {
             spotted
             color_map {  C_map_steel }
             scale 1
             warp {
             turbulence 0
             } 
             
           }
           finish{F_metal_hard}
             
         ]
      [.30  pigment {
             color rgb <.8,.8,.8>
             transmit 0
           }
           finish{F_metal_flat}
  
         ]
          
        }  

  warp {
    turbulence <1.0, 10.0, 20.0>  

  }  

}




//--- brass old
#declare sz = <.6,2,.6> ;   
#declare turb = .5; 
#declare bump = .03; 

#declare T_metal_brass_old =
texture { 
    pigment { 
        spotted 
        color_map { C_map_old_brass }
        turbulence turb
        scale sz
        } 


    
    normal {
         crackle 
         turbulence turb 
         bump_size bump
         scale sz
     }   
 }
 
//--- steel old
#declare sz = <.6,2,.6> ;   
#declare turb = 1.1; 
#declare bump = .03; 

#declare T_steel_old =
texture { 
    pigment { 
        spotted 
        //color_map { C_map_rust_gray } 
        color_map { C_map_rust_gray_dark }
        turbulence turb
        scale sz
        } 


    
    normal {
         crackle 
         turbulence turb 
         bump_size bump
         scale sz
     }   
 }



//--- steel old spotted reddish dents
#declare sz = <1,1,1>*.5 ;   
#declare turb = .5; 
#declare bump = .21; 

#declare T_steel_spotted =
texture { 
    pigment { 
        spotted 
        color_map {C_map_rust_overlay} 
        turbulence turb
        scale sz
        } 

    finish{F_metal_dull}
    
    normal {
        pigment_pattern{ 
            spotted 
            color_map {C_map_rust_normal} 
            turbulence turb
            scale sz
         }  
         bump_size bump
     }   
 }


//--- steel old spotted reddish dents
#declare sz = <1,1,1>*.5 ;   
#declare turb = 1.1; 
#declare bump = .02; 

#declare T_steel_spotted_gray =
texture { 
    pigment { 
        spotted 
        color_map {C_map_gray_overlay} 
        turbulence turb
        scale sz
        } 

    finish{F_old_steel}
    
    normal {
        pigment_pattern{ 
            spotted 
            color_map {C_map_rust_normal} 
            turbulence turb
            scale sz
         }  
         bump_size bump
     }   
 }






     
// -----------------------------------------------------------------------------------------
//                      M A T E R I A L S
//------------------------------------------------------------------------------------------ 


// M_metal_lead
// M_metal_steel
// M_metal_gold
// M_spool
// M_bleaker_black_plastic
// M_panel_gray
// M_galvanize
// M_metal_steel_old
// M_steel_aged
// M_steel_oxidized
// M_gold_resin
// M_metal_chrome
// M_old_copper
//
//
// M_black_rubber
// M_red_rubber
//
//
// M_black_gloss
// M_gold_gloss 
// M_red_gloss
// M_red_dark_gloss
// M_yellow_gloss
// M_blue_gloss
// M_blue_charcoal_gloss
// M_sea_green_gloss
// M_sg_maroon_gloss
// M_white_gloss
// M_tan_gloss
// M_tan_dark_gloss




#declare M_metal_lead = 
material{ 
    texture{ 
        pigment{ rgb C_gray90 } 
        finish{F_metal_lead}
    }
}


#declare M_metal_steel = 
material{ 
    texture{ 
        pigment{ rgb C_gray90 } 
        finish{F_metal_steel}
    }
} 


#declare M_metal_gold = 
material{ texture{  pigment{ rgb C_gold } finish{F_metal_polished}} }


#declare M_spool = 
material { 
    texture{ 
        pigment{ C_gray_blue*1 } 
        finish { phong 1 }
    }
}


#declare M_bleaker_black_plastic =
material {
    texture {
       pigment { C_breaker_black }
       finish  { F_plastic }
   }
}

#declare M_panel_gray =
material {
    texture {
       pigment { C_panel_gray }
       finish  { F_plastic }
   }
}





#declare M_galvanize = material { texture {T_galvanize } scale <20,20,20> }
#declare M_metal_steel_old = material { texture { T_metal_steel_old }}


#declare M_steel_aged =
material {
   texture { T_metal_steel_old }
   texture { T_metal_steel_spotted scale <1.5,1.5,1.5>}
}  


#declare M_brass_aged =
material {
   texture { T_metal_brass_old }
   texture { T_metal_brass_spotted scale <1.5,1.5,1.5>}
}  




#declare M_steel_pitted =
material {
   texture { T_galvanize        scale <5,5,5>}
   texture { T_metal_pitted     scale <.5,.5,.5>}
} 

   
#declare M_steel_oxidized =
material {
   texture { T_galvanize        scale <10,10,10>}
   texture { T_metal_oxidized   scale <2,2,2>}
} 


#declare M_steel_aged_2 =
material {
   texture { T_steel_old      scale <2,2,2>}
   texture { T_steel_spotted  scale <1,1,1>}
}






#declare M_steel_black_rough =
material {
   texture { T_steel_black  scale <10,10,10>}
   //texture { T_metal_oxidized   scale <2,2,2>}
}

//

//--- gold_resin        
#declare M_gold_resin =
material {
    texture {
        pigment {
            bozo 
            color_map {C_map_old_copper }
        } 
       finish { F_metal_steel }
    }  
}


//--- chrome
#declare M_metal_chrome = 
material{ 
    texture{ 
        pigment{ color red 0.8 green 0.8 blue 0.8 }   
        finish{ F_metal_polished }
     } 
}



//--- copper        
#declare M_old_copper =
material {
    texture {
        pigment {
            bozo 
            color_map {C_map_old_copper }
        } 
       finish { F_metal_dull }
    }  
}      
        

#declare M_white_gloss =
material {
    texture {
       pigment { C_white }
       finish  { F_gloss }
   }
}

#declare M_tan_gloss =
material {
    texture {
       pigment { C_tan }
       finish  { F_gloss }
   }
}

#declare M_tan_dark_gloss =
material {
    texture {
       pigment { C_tan_dark }
       finish  { F_gloss }
   }
}


#declare M_putty_gloss =
material {
    texture {
       pigment { C_putty  }
       finish  { F_gloss }
   }
}

#declare M_black_gloss =
material {
    texture {
       pigment { C_black }
       finish { F_gloss }
   }
}

#declare M_black_plastic =
material {
    texture {
       pigment { C_black }
       finish { F_plastic }
   }
}


#declare M_dark_gray_plastic =
material {
    texture {
       pigment { C_gray_black }
       finish { F_plastic }
   }
}

#declare M_gold_gloss =
material {
    texture {
       pigment { C_gold }
       finish { F_gloss }
   }
}

#declare M_red_gloss =
material {
    texture {
       pigment { C_red }
       finish { F_gloss }
   }
}

#declare M_red_dark_gloss =
material {
    texture {
       pigment { C_red_dark*.75 }
       finish { F_gloss }
   }
}

#declare M_yellow_gloss =
material {
    texture {
       pigment { C_yellow }
       finish { F_gloss }
   }
}

#declare M_yellow_dull =
material {
    texture {
       pigment { C_yellow_dull }
       finish { F_dull }
   }
}


#declare M_blue_gloss =
material {
    texture {
       pigment { C_blue }
       finish { F_gloss }
   }
}

#declare M_blue_dark_gloss =
material {
    texture {
       pigment { C_blue_dark }
       finish { F_gloss }
   }
}



#declare M_blue_charcoal_gloss =
material {
    texture {
       pigment {C_blue_charcoal }
       finish { F_gloss }
   }
}


#declare M_sea_green_gloss =
material {
    texture {
       pigment { C_sea_green }
       finish { F_gloss }
   }
}





#declare M_sg_maroon_gloss =
material {
    texture {
       pigment { C_maroon }
       finish { F_gloss }
   }
}

#declare M_glass =
material {
    texture {T_glass}
    interior {I_glass}
}


#declare M_black_rubber =
material {
    texture {
       pigment { C_black }
       finish { F_rubber }
   }
}

#declare M_black_dull =
material {
    texture {
       pigment { C_black }
       finish { F_dull }
   }
}


#declare M_gray40_gloss =
material {
    texture {
       pigment { C_gray40 }
       finish  { F_gloss }
   }
}

#declare M_gray30_gloss =
material {
    texture {
       pigment { C_gray30 }
       finish  { F_gloss }
   }
}

#declare M_gray_dark_dull =
material {
    texture {
       pigment { C_gray_dark }
       finish { F_dull }
   }
}


#declare M_red_rubber =
material {
    texture {
       pigment { C_red }
       finish { F_rubber }
   }
}

#declare M_gold_rubber =
material {
    texture {
       pigment { C_gold }
       finish { F_rubber }
   }
}

#declare M_black_rubber_grip =
material {
    texture {
       pigment { C_gray_black    }
       finish  { F_rubber   }
       normal  { N_ripple_A }
   }
}


#declare M_tan_dark_dull =
material {
    texture {
       pigment { C_tan_dark }
       finish  { F_dull }
   }
}

#declare M_white_glow = 
material{ 
    texture{ 
        pigment {C_white} 
        finish {F_glow} 
        } 
}



#declare M_old_trim =  
#declare sz = 5 ;   
#declare turb = 1.25; 
#declare bump = .05; 
material{ 
    texture{ 
        pigment { 
            spotted 
                    colour_map {
                    [0.00, C_horizon_blue *.2] 
                    [0.55, C_horizon_blue *.2]
                    [0.6,  C_horizon_blue *.15]
                    [0.7,  C_horizon_blue *.2]
                    [0.8,  C_horizon_blue *.2]
                    [1.00, C_horizon_blue *.2]
                    } 
            turbulence turb
            scale sz
        } 
        finish {F_soft_plastic}
        
        normal { 
            pigment_pattern{ 
                spotted 
                turbulence turb
                colour_map {[0.00, rgb  .7] 
                            [0.55, rgb  1]
                            [0.6,  rgb  0]
                            [0.7,  rgb .6]
                            [0.8,  rgb  1]
                            [1.00, rgb  .7]
                            } 
             } 
             bump_size bump
             scale sz
        }

      } 
}



#declare M_old_trim_2 =  
#declare sz = 5 ;   
#declare turb = .8; 
#declare bump = .1; 
material{ 
    texture{ 
        pigment { 
            spotted 
                    colour_map {
                    [0.00, C_tan *.7] 
                    [0.55, C_tan ]
                    [0.6,  C_tan*.8 ]
                    [0.7,  C_tan*.8]
                    [0.8,  C_tan ]
                    [1.00, C_tan *.8]
                    } 
            turbulence turb
            scale sz
        } 
        finish {F_soft_plastic}
        
        normal { 
            pigment_pattern{ 
                spotted 
                turbulence turb
                colour_map {[0.00, rgb  .7] 
                            [0.55, rgb  1]
                            [0.6,  rgb  0]
                            [0.7,  rgb .6]
                            [0.8,  rgb  1]
                            [1.00, rgb  .7]
                            } 
             } 
             bump_size bump
             scale sz
        }

      } 
}


//CM_stain




#declare M_old_wall = 
material{ 
    texture{ 
        pigment {C_tan} 
        finish {F_soft_plastic}
        normal {N_granite_A scale <20,20,20> }
        } 
}



#declare M_gold_glow = 
material{ 
    texture{ 
        pigment {C_gold} 
        finish {F_glow}
        } 
}  

#declare M_white_glow = 
material{ 
    texture{ 
        pigment {C_white} 
        finish {F_glow}
        } 
}

#declare M_black_glow = 
material{ 
    texture{ 
        pigment {C_black} 
        finish {F_glow}
        } 
}


#declare M_old_floor = 
material{ 
    texture{ 
        pigment {C_tan*.4} 
        finish {F_concrete_smooth}
        normal {N_granite_A scale <50,50,50> }
        } 
}     



#declare M_plastic_tan =
material {
    texture {
       pigment { C_tan }
       finish  { F_plastic }
   }
}

#declare M_plastic_black =
material {
    texture {
       pigment { C_black }
       finish  { F_plastic }
   }
}


#declare M_enviroment_sunny =
material {
    texture {
        pigment {
            gradient y
            color_map{C_map_enviroment_sunny }
        }
    finish {F_dull}    
    }
}
  
// metals
#declare M_metal_alum = material{ texture{ T_gray80    finish{F_metal_dull}} interior{I_solid} }
#declare M_metal_steel = material{ texture{ T_gray70    finish{F_metal_hard}} interior{I_solid} } 
#declare M_metal_steel2 = material{ texture{ T_map_steel } scale 15} 
#declare M_metal_chrome = material{ texture{ T_gray80    finish{F_metal_polished}} interior{I_solid} }
#declare M_metal_gold = material{ texture{ T_gold    finish{F_metal_polished}} interior{I_solid} }
#declare M_metal_gold_bright = material{ texture{ T_gold_bright    finish{F_metal_polished}} interior{I_solid} } 


// glass 
#declare M_glass = material{ texture{ T_clear_black    finish{F_hard_glass}} interior{I_clear} }  
#declare M_glass_dark = material{ texture{ T_clear_black    finish{F_hard_glass}} interior{I_dark} }
#declare M_glass_red = material{ texture{ T_clear_black    finish{F_hard_glass}} interior{I_red} }
#declare M_glass_gold = material{ texture{ T_clear_black    finish{F_hard_glass}} interior{I_gold} }
#declare M_glass_green = material{ texture{ T_clear_black    finish{F_hard_glass}} interior{I_green} }
#declare M_glass_green_light = material{ texture{ T_clear_black    finish{F_hard_glass}} interior{I_green_light} }
#declare M_glass_blue = material{ texture{ T_clear_black    finish{F_hard_glass}} interior{I_blue} }
#declare M_glass_milk = material{ texture{ T_clear_white    finish{F_milky}} interior{I_white} }
#declare M_glass_frosted = material{ texture{ T_clear_black normal{N_ripple_A scale .05} finish{F_milky}} interior{I_white} }
#declare M_glass_wripple = material{ texture{ T_clear_black normal{N_ripple_A scale 2} finish{F_milky}} interior{I_white} }
#declare M_glass_gold_frost = material{ texture{ T_clear_black normal{N_ripple_A scale .1} finish{F_hard_glass}} interior{I_gold} }
#declare M_glass_gold_wripple = material{ texture{ T_clear_black normal{N_ripple_A} finish{F_hard_glass}} interior{I_gold} }
#declare M_glass_gold_pillow = material{ texture{ T_clear_black normal{N_ripple_A scale 9} finish{F_hard_glass}} interior{I_gold} }
#declare M_gray50_gloss_ripple = material{ texture{ T_gray50 normal{N_ripple_A scale 9} finish{F_metal_hard}} interior{I_solid} }
#declare M_metal_chrome_ripple = material{ texture{ T_gray80 normal{N_ripple_A } finish{F_metal_polished}} interior{I_solid} rotate x*90}
#declare M_glass_green_light_ripple = material{ texture{ T_clear_black normal{N_ripple_large} finish{F_hard_glass}} interior{I_green_light} }
#declare M_metal_gold_ripple = material{ texture{ T_gold_bright normal{N_ripple_A scale .6} finish{F_metal_polished}} interior{I_solid} }
#declare M_normal_study = material{ texture{ T_tan    finish{F_metal_hard}} interior{I_solid} }

#declare M_glass_blue_dark = material{ texture{ T_clear_black    finish{F_hard_glass}} interior{I_blue_dark} }





//--- clear gloss
#declare M_clear_gloss =
material { 
    texture{
        pigment{ 
            Transparent
        } 
        finish { 
            ambient .2
            brilliance 4
            diffuse 1
            specular 1
            roughness 1/100
            phong 1
            phong_size 120 //fresnel 
            reflection {.01, .7 fresnel}
        }
    }
}








 